#include <cstring>
#include <jni.h>
#include <cassert>

#include <android/log.h>

namespace{
	// see https://stackoverflow.com/questions/12900695/how-to-obtain-jni-interface-pointer-jnienv-for-asynchronous-calls
	// on how to store jnienv globally
	void log(JNIEnv* env) {
		__android_log_write( ANDROID_LOG_ERROR, "hello.cpp", "use __android_log_write for logging" );
		assert(env);
		jclass clazz = env ? env->FindClass("com/example/hello/HelloFromCPP") : nullptr;
		assert(clazz != nullptr);
		jmethodID methodID = clazz ? env->GetStaticMethodID(clazz, "log", "()V") : nullptr;
		assert(methodID != nullptr);
		(methodID && clazz) ? env->CallStaticVoidMethod(clazz, methodID) : void();
	}
}

extern "C"{
	jstring Java_com_example_hello_HelloFromCPP_message( JNIEnv* env, jobject obj ) {
		(void) obj;
		log(env);
		return env->NewStringUTF("Hello from C++"); // is this a leak?
	}
}
