package com.example.hello;

import android.util.Log;

public class HelloFromCPP {
  public native static String message();

  // used as callback from JNI code
  public static void log(){
    Log.e("cmakeapp", "callback from c++ code");
  }

  static {
    Log.e("cmakeapp", "loadLibrary hello");
    try{
    System.loadLibrary("hello");
      Log.e("cmakeapp", "libhello loaded");
    } catch (Throwable ex){
      Log.e("cmakeapp", "loadLibrary failed", ex);
      throw ex;
    }
  }
}
