package com.example;

import android.app.Activity;
import android.os.Bundle;
import android.widget.TextView;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;


import com.example.R;

import com.example.KotlinKt; // java depends on kotlin, and kotlin might depend on java...
import com.example.hello.Hello;
import com.example.hello.HelloFromCPP;

public class MainActivity extends Activity {
  @Override
  protected void onCreate(Bundle savedInstanceState) {
    Log.e("cmakeapp", "fekir onCreate");
    super.onCreate(savedInstanceState);
    try{
      String s = this.getString(R.string.made_with_cmake);
      //setContentView(R.layout.activity_main);
      //TextView textView = findViewById(R.id.my_text);
      View view = LayoutInflater.from(this).inflate(R.layout.activity_main, null);
      TextView textView = view.findViewById(R.id.my_text);
      textView.setText(s + "\n "
                         + KotlinKt.message() + "\n "
                         + Hello.message()  + "\n "
                         + HelloFromCPP.message() + "\n "
      );
      setContentView(view);
    } catch (Exception ex){
      TextView textView = new TextView(this);
      textView.setText( "an error occurred while creating the view:\n" + ex.getMessage());
      setContentView(textView);
    }
  }

  static String name(){
    return "MainActivity";
  }
}
